<?php
include_once'../connectdb.php';

require __DIR__ . '/autoload.php'; //Nota: si renombraste la carpeta a algo diferente de "ticket" cambia el nombre en esta línea
use Mike42\Escpos\EscposImage;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
use Mike42\Escpos\Printer;

$id=$_GET['id'];
$soma=$pdo->prepare("SELECT si.idsaida, s.data as data, s.hora, s.id, s.agente as nome,  si.ordem_saidas as ordem, si.quantidade as qtd, SUM(si.valor) as valor, si.idproduto, p.id, p.designacao as produto, p.marca as marca, p.modelo as modelo, p.cor as cor 
						FROM saida_itens si
						INNER JOIN saida s ON s.id = si.idsaida
						INNER JOIN produto p ON p.id = si.idproduto
						WHERE si.idsaida = $id");
$soma->execute();
$resumo=$soma->fetch(PDO::FETCH_OBJ);

$nombre_impresora = "POS-80C";

$connector = new WindowsPrintConnector($nombre_impresora);
$printer = new Printer($connector);
$printer->setJustification(Printer::JUSTIFY_CENTER);

$logo = EscposImage::load("innparadise.png", false);
$printer->bitImage($logo);
/*

Imprimimos un mensaje. Podemos usar
el salto de línea o llamar muchas
veces a $printer->text()
 */
$printer -> selectPrintMode(Printer::MODE_FONT_A);
$printer->setTextSize(2, 2);
$printer->setJustification(Printer::JUSTIFY_CENTER);
$printer->setTextSize(1, 1);
$printer->feed();
$printer->text('NUIT: 120111868  | Cell: 84600600');
$printer->feed();
$printer->text('PEDIDO DE CONTA Nº: '.$id);
$printer->feed(3);
$printer->setJustification(Printer::JUSTIFY_LEFT);
$printer->text("-------------------------------------------");
$printer->feed();
$printer->text("Qtd Descricao                           TOTAL");
$printer->feed();
$printer->text("-------------------------------------------");

$select=$pdo->prepare("SELECT si.idsaida, s.data as data, s.hora, s.id, s.agente as nome,  si.ordem_saidas as ordem, si.quantidade as qtd, si.valor as valor, si.idproduto, p.id, p.designacao as produto, p.marca as marca, p.modelo as modelo, p.cor as cor 
						FROM saida_itens si
						INNER JOIN saida s ON s.id = si.idsaida
						INNER JOIN produto p ON p.id = si.idproduto
						WHERE si.idsaida = $id");
$select->execute();
$printer->feed();
while($item=$select->fetch(PDO::FETCH_OBJ)){
$printer->setJustification(Printer::JUSTIFY_LEFT);
$printer->text(substr($item->qtd, 0, 4).'  '.substr($item->produto.' '.$item->marca.' '.$item->modelo.'                         '.$item->cor, 0, 30).' '. number_format($item->valor,2).'MT');
$printer->feed();	
}
$printer->setJustification(Printer::JUSTIFY_RIGHT);

$printer->text("-------------------");
$printer->feed();
$printer->text('TOTAL: '.number_format($resumo->valor,2).'MT');
$printer->feed();
$printer->text("-------------------");
$printer->feed(2);
$printer->setJustification(Printer::JUSTIFY_CENTER);
$printer->text('Operador: '.$resumo->nome.'');
$printer->feed();
$printer->text('Data: '.$resumo->data.'  Hora: '.$resumo->hora);
$printer->feed();
$printer->text("-----------------------");
$printer->feed(2);
$printer->text('Obrigado, Volte sempre!');
$printer->feed();
$printer->text("ESTE RECIBO NÃO É DOCUMENTO FISCAL");

$printer->feed(3);
$printer->text("-------------------------------------------");
$printer->feed();
$printer->text('ACLIVEN Software © Todos os Direitos Reservados');

echo '<meta http-equiv="refresh" content="0; url=../venda/index.php?link=1">';
/*
Hacemos que el papel salga. Es como
dejar muchos saltos de línea sin escribir nada
 */
$printer->feed(2);

/*
Cortamos el papel. Si nuestra impresora
no tiene soporte para ello, no generará
ningún error
 */
$printer->cut();

/*
Por medio de la impresora mandamos un pulso.
Esto es útil cuando la tenemos conectada
por ejemplo a un cajón
 */
$printer->pulse();

/*
Para imprimir realmente, tenemos que "cerrar"
la conexión con la impresora. Recuerda incluir esto al final de todos los archivos
 */
$printer->close();
