<?php
include_once'../conexao.php';

require __DIR__ . '/autoload.php'; //Nota: si renombraste la carpeta a algo diferente de "ticket" cambia el nombre en esta línea
use Mike42\Escpos\EscposImage;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
use Mike42\Escpos\Printer;

$id=$_GET['pr'];

$nombre_impresora = "POS-80C";

$connector = new WindowsPrintConnector($nombre_impresora);
$printer = new Printer($connector);
$printer->setJustification(Printer::JUSTIFY_CENTER);

$logo = EscposImage::load("innparadise.png", false);
$printer->bitImage($logo);

/*
Imprimimos un mensaje. Podems usar
el salto de línea o llamar muchas
veces a $printer->text()
*/

$printer->selectPrintMode(Printer::MODE_FONT_A);
$printer->setTextSize(2, 2);
$printer->setJustification(Printer::JUSTIFY_CENTER);
$printer->setTextSize(1, 1);
$printer->feed();
$printer->text('NUIT: 120111868  | Cell: 84600600');
$printer->feed();
$printer->text('PEDIDO PARA COZINHA Nº: '.$id.'/'.date('Y'));
$printer->feed(3);
$printer->setJustification(Printer::JUSTIFY_LEFT);
$printer->text("-------------------------------------------");
$printer->feed();
$printer->text("Qtd Descricao                           TOTAL");
$printer->feed();
$printer->text("-------------------------------------------");

$consult=mysqli_query($mysqli,"select s.idproduto, s.idsaida as idsaida, s.estado, p.id, p.tipo, s.estado, s.quantidade
								from saida_itens s 
								INNER JOIN produto p ON p.id = s.idproduto
								where s.idsaida = '$id' and  p.tipo = 'Cozinha' and s.estado = 0");
$printer->feed();
while($listar=mysqli_fetch_array($consult)){
$idp=$listar['idproduto'];
$idsaida=$listar['id'];
$estado=$listar['estado'];
$con=mysqli_query($mysqli,"SELECT * FROM produto where id = $idp and tipo = 'Cozinha'");
$lis=mysqli_fetch_array($con);

$printer->setJustification(Printer::JUSTIFY_LEFT);
$printer->text(substr($listar['quantidade'], 0, 4).'  '.substr($lis['designacao'].' '.$lis['marca'].' '.$lis['modelo'].'                         '.$lis['cor'], 0, 30).' '. number_format($lis['preco_venda'],2).'MT');
$printer->feed();	
}

$consultar=mysqli_query($mysqli,"select SUM(s.valor) as total, s.idproduto, s.idsaida as idsaida, s.estado, p.id, p.tipo, s.estado
								from saida_itens s 
								INNER JOIN produto p ON p.id = s.idproduto
								where s.idsaida =$id and  p.tipo = 'Cozinha' and s.estado = 0");
$resumo=mysqli_fetch_array($consultar);

$printer->setJustification(Printer::JUSTIFY_RIGHT);
$printer->text("-------------------");
$printer->feed();
$printer->text('TOTAL: '.number_format($resumo['total'],2).'MT');
$printer->feed();
$printer->text("-------------------");
$printer->feed(2);

$saida=mysqli_query($mysqli,"SELECT * FROM saida where id = $id");
$user=mysqli_fetch_array($saida);

$printer->setJustification(Printer::JUSTIFY_CENTER);
$printer->text('Operador: '.$user['agente'].'');
$printer->feed();
$printer->text('Data: '.$user['data'].'  Hora: '.$user['hora']);
$printer->feed();
$printer->text("-----------------------");
$printer->feed(2);
$printer->text('Obrigado, Volte sempre!');
$printer->feed();
$printer->text("ESTE RECIBO NÃO É DOCUMENTO FISCAL");

$printer->feed(3);
$printer->text("-------------------------------------------");
$printer->feed();
$printer->text('ACLIVEN Software © Todos os Direitos Reservados');

$stmt = mysqli_query($mysqli,"UPDATE saida_itens SET estado = 1 WHERE idsaida = $id");
if($stmt!=''){
	
}
echo '<meta http-equiv="refresh" content="0; url=../venda/index.php?link=1">';
/*
Hacemos que el papel salga. Es como
dejar muchos saltos de línea sin escribir nada
 */
$printer->feed(2);

/*
Cortamos el papel. Si nuestra impresora
no tiene soporte para ello, no generará
ningún error
 */
$printer->cut();

/*
Por medio de la impresora mandamos un pulso.
Esto es útil cuando la tenemos conectada
por ejemplo a un cajón
 */
$printer->pulse();

/*
Para imprimir realmente, tenemos que "cerrar"
la conexión con la impresora. Recuerda incluir esto al final de todos los archivos
 */
$printer->close();
